/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.datagen;

import java.util.function.Supplier;
import mrthomas20121.tinkers_reforged.datagen.ReforgedMaterials;
import mrthomas20121.tinkers_reforged.init.CastType;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedBlocks;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedFluids;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedItems;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedModifiers;
import mrthomas20121.tinkers_reforged.item.CastObject;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.util.StaticModifier;

public class ReforgedLang
extends LanguageProvider {
    public ReforgedLang(DataGenerator gen) {
        super(gen, "tinkers_reforged", "en_us");
    }

    protected void addTranslations() {
        this.addGroup("Tinkers Reforged Items");
        this.add("pattern.tinkers_reforged.great_blade", "Great Blade Pattern");
        this.add("pattern.tinkers_reforged.large_round_plate", "Large Round Plate Pattern");
        this.addItem((Supplier)TinkersReforgedItems.book, "Reforging Guide");
        this.addItem((Supplier)TinkersReforgedItems.GREAT_BLADE, "Great Blade");
        this.addItem((Supplier)TinkersReforgedItems.LARGE_ROUND_PLATE, "Large Round Plate");
        this.addItem((Supplier)TinkersReforgedItems.FRYING_PAN, "Frying Pan");
        this.addItem((Supplier)TinkersReforgedItems.GREATSWORD, "Greatsword");
        this.add("item.tinkers_reforged.frying_pan.description", "a weapon with burning and healing capabilities.");
        this.add("item.tinkers_reforged.great_sword.description", "a weapon with knockback");
        this.addBlock((Supplier)TinkersReforgedBlocks.aluminum_block, "Aluminum Block");
        this.addBlock((Supplier)TinkersReforgedBlocks.aluminum_ore, "Bauxite Ore");
        this.addBlock((Supplier)TinkersReforgedBlocks.deepslate_aluminum_ore, "Deepslate Bauxite Ore");
        this.addItem((Supplier)TinkersReforgedItems.aluminum_dust, "Aluminum Dust");
        this.addItem((Supplier)TinkersReforgedItems.aluminum_ingot, "Aluminum Ingot");
        this.addItem((Supplier)TinkersReforgedItems.aluminum_nugget, "Aluminum Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.duralumin_block, "Duralumin Block");
        this.addItem((Supplier)TinkersReforgedItems.duralumin_dust, "Duralumin Dust");
        this.addItem((Supplier)TinkersReforgedItems.duralumin_ingot, "Duralumin Ingot");
        this.addItem((Supplier)TinkersReforgedItems.duralumin_nugget, "Duralumin Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.electrical_copper_block, "Electrical Copper Block");
        this.addItem((Supplier)TinkersReforgedItems.electrical_copper_dust, "Electrical Copper Dust");
        this.addItem((Supplier)TinkersReforgedItems.electrical_copper_ingot, "Electrical Copper Ingot");
        this.addItem((Supplier)TinkersReforgedItems.electrical_copper_nugget, "Electrical Copper Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.lavium_block, "Lavium Block");
        this.addItem((Supplier)TinkersReforgedItems.lavium_dust, "Lavium Dust");
        this.addItem((Supplier)TinkersReforgedItems.lavium_ingot, "Lavium Ingot");
        this.addItem((Supplier)TinkersReforgedItems.lavium_nugget, "Lavium Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.qivium_block, "Qivium Block");
        this.addItem((Supplier)TinkersReforgedItems.qivium_dust, "Qivium Dust");
        this.addItem((Supplier)TinkersReforgedItems.qivium_ingot, "Qivium Ingot");
        this.addItem((Supplier)TinkersReforgedItems.qivium_nugget, "Qivium Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.gausum_block, "Gausum Block");
        this.addItem((Supplier)TinkersReforgedItems.gausum_dust, "Gausum Dust");
        this.addItem((Supplier)TinkersReforgedItems.gausum_ingot, "Gausum Ingot");
        this.addItem((Supplier)TinkersReforgedItems.gausum_nugget, "Gausum Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.felsteel_block, "Felsteel Block");
        this.addItem((Supplier)TinkersReforgedItems.felsteel_dust, "Felsteel Dust");
        this.addItem((Supplier)TinkersReforgedItems.felsteel_ingot, "Felsteel Ingot");
        this.addItem((Supplier)TinkersReforgedItems.kepu_ore, "Kepu Ore");
        this.addBlock((Supplier)TinkersReforgedBlocks.kepu_block, "Kepu Block");
        this.addItem((Supplier)TinkersReforgedItems.kepu_dust, "Kepu Dust");
        this.addItem((Supplier)TinkersReforgedItems.kepu_ingot, "Kepu Ingot");
        this.addItem((Supplier)TinkersReforgedItems.kepu_nugget, "Kepu Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.chorus_metal_block, "Chorus Metal Block");
        this.addItem((Supplier)TinkersReforgedItems.chorus_metal_dust, "Chorus Metal Dust");
        this.addItem((Supplier)TinkersReforgedItems.chorus_metal_ingot, "Chorus Metal Ingot");
        this.addItem((Supplier)TinkersReforgedItems.chorus_metal_nugget, "Chorus Metal Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.durasteel_block, "Durasteel Block");
        this.addItem((Supplier)TinkersReforgedItems.durasteel_dust, "Durasteel Dust");
        this.addItem((Supplier)TinkersReforgedItems.durasteel_ingot, "Durasteel Ingot");
        this.addItem((Supplier)TinkersReforgedItems.durasteel_nugget, "Durasteel Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.crusteel_block, "Crusteel Block");
        this.addItem((Supplier)TinkersReforgedItems.crusteel_dust, "Crusteel Dust");
        this.addItem((Supplier)TinkersReforgedItems.crusteel_ingot, "Crusteel Ingot");
        this.addItem((Supplier)TinkersReforgedItems.crusteel_nugget, "Crusteel Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.wavy_block, "Wavy Block");
        this.addItem((Supplier)TinkersReforgedItems.wavy_dust, "Wavy Dust");
        this.addItem((Supplier)TinkersReforgedItems.wavy_ingot, "Wavy Ingot");
        this.addItem((Supplier)TinkersReforgedItems.wavy_nugget, "Wavy Nugget");
        this.addBlock((Supplier)TinkersReforgedBlocks.yokel_block, "Yokel Block");
        this.addItem((Supplier)TinkersReforgedItems.yokel_dust, "Yokel Dust");
        this.addItem((Supplier)TinkersReforgedItems.yokel_ingot, "Yokel Ingot");
        this.addItem((Supplier)TinkersReforgedItems.yokel_nugget, "Yokel Nugget");
        this.addItem((Supplier)TinkersReforgedItems.raw_aluminum, "Raw Bauxite");
        this.addItem((Supplier)TinkersReforgedItems.raw_kepu, "Raw Kepu");
        this.addBlock((Supplier)TinkersReforgedBlocks.raw_aluminum_block, "Raw Bauxite Block");
        this.addBlock((Supplier)TinkersReforgedBlocks.raw_kepu_block, "Raw Kepu Block");
        this.addCast(TinkersReforgedItems.great_blade_cast);
        this.addCast(TinkersReforgedItems.large_round_plate_cast);
        this.addFluid(TinkersReforgedFluids.redstone, "Liquid Redstone");
        this.addFluid(TinkersReforgedFluids.duralumin, "Molten Duralumin");
        this.addFluid(TinkersReforgedFluids.electrical_copper, "Molten Electrical Copper");
        this.addFluid(TinkersReforgedFluids.lavium, "Molten Lavium");
        this.addFluid(TinkersReforgedFluids.qivium, "Molten Qivium");
        this.addFluid(TinkersReforgedFluids.blazing_copper, "Molten Blazing Copper");
        this.addFluid(TinkersReforgedFluids.gausum, "Molten Gausum");
        this.addFluid(TinkersReforgedFluids.lapis, "Molten Lapis");
        this.addFluid(TinkersReforgedFluids.felsteel, "Molten Felsteel");
        this.addFluid(TinkersReforgedFluids.kepu, "Molten Kepu");
        this.addFluid(TinkersReforgedFluids.chorus_metal, "Molten Chorus Metal");
        this.addFluid(TinkersReforgedFluids.chorus, "Molten Chorus");
        this.addFluid(TinkersReforgedFluids.shulker, "Molten Shulker");
        this.addFluid(TinkersReforgedFluids.kelp, "Molten Kelp");
        this.addFluid(TinkersReforgedFluids.durasteel, "Molten Durasteel");
        this.addFluid(TinkersReforgedFluids.crusteel, "Molten Crusteel");
        this.addFluid(TinkersReforgedFluids.wavy, "Molten Wavy");
        this.addFluid(TinkersReforgedFluids.yokel, "Molten Yokel");
        this.addFluid(TinkersReforgedFluids.proto_lava, "Molten Proto Lava");
        this.add(TinkersReforgedFluids.redstone.get().m_6859_(), "Liquid Redstone Bucket");
        this.add(TinkersReforgedFluids.duralumin.get().m_6859_(), "Molten Duralumin Bucket");
        this.add(TinkersReforgedFluids.electrical_copper.get().m_6859_(), "Molten Electrical Copper Bucket");
        this.add(TinkersReforgedFluids.lavium.get().m_6859_(), "Molten Lavium Bucket");
        this.add(TinkersReforgedFluids.qivium.get().m_6859_(), "Molten Qivium Bucket");
        this.add(TinkersReforgedFluids.gausum.get().m_6859_(), "Molten Gausum Bucket");
        this.add(TinkersReforgedFluids.lapis.get().m_6859_(), "Molten Lapis Bucket");
        this.add(TinkersReforgedFluids.blazing_copper.get().m_6859_(), "Molten Blazing Copper Bucket");
        this.add(TinkersReforgedFluids.felsteel.get().m_6859_(), "Molten Felsteel Bucket");
        this.add(TinkersReforgedFluids.kepu.get().m_6859_(), "Molten Kepu Bucket");
        this.add(TinkersReforgedFluids.chorus_metal.get().m_6859_(), "Molten Chorus Metal Bucket");
        this.add(TinkersReforgedFluids.chorus.get().m_6859_(), "Molten Chorus Bucket");
        this.add(TinkersReforgedFluids.shulker.get().m_6859_(), "Molten Shulker Bucket");
        this.add(TinkersReforgedFluids.durasteel.get().m_6859_(), "Molten Durasteel Bucket");
        this.add(TinkersReforgedFluids.kelp.get().m_6859_(), "Molten Kelp Bucket");
        this.add(TinkersReforgedFluids.crusteel.get().m_6859_(), "Molten Crusteel Bucket");
        this.add(TinkersReforgedFluids.wavy.get().m_6859_(), "Molten Wavy Bucket");
        this.add(TinkersReforgedFluids.yokel.get().m_6859_(), "Molten Yokel Bucket");
        this.add(TinkersReforgedFluids.proto_lava.get().m_6859_(), "Molten Proto Lava Bucket");
        this.add("effect.tinkers_reforged.electro_web", "Electro Web");
        this.add("effect.tinkers_reforged.fungal", "Fungal");
        for (CastType type : CastType.values()) {
            Item item = (Item)TinkersReforgedItems.casts.get((Object)type).get();
            this.add(item, String.format("%s Aluminum Cast", this.capitalize(type.name().toLowerCase())));
        }
        this.addMaterial(ReforgedMaterials.duralumin, "Duralumin", "One of the earliest types of age-hardenable aluminum alloys", "German metal");
        this.addMaterial(ReforgedMaterials.electrical_copper, "Electrical Copper", "It's not as electric as people think", "Copper that was Electrified");
        this.addMaterial(ReforgedMaterials.lavium, "Lavium", "Cobalt Alloy", "Strong Cobalt Alloy");
        this.addMaterial(ReforgedMaterials.qivium, "Qivium", "Cobalt Alloy", "Strong Cobalt Alloy");
        this.addMaterial(ReforgedMaterials.gausum, "Gausum", "Ancient Debris Alloy", "Strong Ancient Debris Alloy");
        this.addMaterial(ReforgedMaterials.felsteel, "Felsteel", "Ancient Debris Alloy", "From the depth of the nether");
        this.addMaterial(ReforgedMaterials.chorus_metal, "Chorus Metal", "Chorus and Shulker alloy", "Chorus and Shulker alloy");
        this.addMaterial(ReforgedMaterials.kepu, "Kepu", "Come from the depth of the end", "Infused End Ore");
        this.addMaterial(ReforgedMaterials.durasteel, "Durasteel", "Wait it's not an ore?", "Mix of Ender and Netherite");
        this.addMaterial(ReforgedMaterials.crusteel, "Crusteel", "Nether Crust", "Copper nether alloy");
        this.addMaterial(ReforgedMaterials.wavy, "Wavy", "This smell bad", "Mushroom material");
        this.addMaterial(ReforgedMaterials.yokel, "Yokel", "Finally a sea metal", "Kelp alloy");
        this.addModifier(TinkersReforgedModifiers.gausum_titanic_damage, "Titanic Damage", "that's a lot of damage!", "Deal more damage to enemy with more HP than you.");
        this.addModifier(TinkersReforgedModifiers.lavium_aridzone, "Arid Zone", "That's quite hot!", "Increase mining speed and damage in hot/arid area");
        this.addModifier(TinkersReforgedModifiers.duralumin_ultra_durable, "Ultra Durable", "Anyone need Duritos?", "Your tool last longer most of the time.");
        this.addModifier(TinkersReforgedModifiers.electrical_copper_electro_web, "Electro Web", "Shocking isn't it?", "Apply Electro Web to an entity after hit.");
        this.addModifier(TinkersReforgedModifiers.qivium_blazing_fire, "Burning Capacitor", "Overpowered!", "Repair the tool when you are on fire.");
        this.addModifier(TinkersReforgedModifiers.felsteel_fel_debris, "Fel Debris", "Watch out!", "Deal more damage to things in the nether but deal less damage to things in the end.");
        this.addModifier(TinkersReforgedModifiers.chorus_metal_levitating_blob, "Levitating Blob", "It's yours my friend!", "Spawn a Shulker blob on hit.");
        this.addModifier(TinkersReforgedModifiers.kepu_damage_lock, "Damage Lock", "No Damage?", "Your weapon can only do damage in the end.");
        this.addModifier(TinkersReforgedModifiers.cutting_edge, "Cutting Edge", "That's a lot of damage!", "Deal 10% more damage.");
        this.addModifier(TinkersReforgedModifiers.durasteel_adapting, "Adapting", "1up", "Each mob killed increase your stats by 0.1.");
        this.addModifier(TinkersReforgedModifiers.giant_cells, "Giant Cells", "Micro Friends", "Mine Faster the lower your Health are.");
        this.addModifier(TinkersReforgedModifiers.terra, "Terra", "Caught between a rock and a hard place.", "Mine stone blocks faster(controlled by a tag)");
        this.addModifier(TinkersReforgedModifiers.spore_shot, "Spore Shot", "MMM Mushrooms.", "Apply Fungal on it. Entity with fungal take 2% of their health as damage when hit.");
        this.add("modifier.tinkers_reforged.adapting.attack_damage", "Adapting damage");
        this.add("modifier.tinkers_reforged.adapting.mining_speed", "Adapting mining speed");
        this.add("modifier.tinkers_reforged.fel_debris.bonus", "Damage in the current dimension");
        this.add("modifier.tinkers_reforged.arid_zone.attack_damage", "Bonus damage in the current biome");
        this.add("modifier.tinkers_reforged.arid_zone.mining_speed", "Bonus mining speed in the current biome");
        this.add("modifier.tinkers_reforged.damage_lock.end_bonus", "Bonus Attack Damage in the end");
        this.add("modifier.tinkers_reforged.giant_cells.mining_speed", "Bonus mining speed");
        this.add("modifier.tinkers_reforged.adapting.cap", "You have reach the max bonus you can get with adapting");
    }

    public void addCast(CastObject object) {
        this.addItem((Supplier)object.getGoldCast(), this.capitalize(object.getName().m_135815_()));
        this.addItem((Supplier)object.getSandCast(), "Sand " + this.capitalize(object.getName().m_135815_()));
        this.addItem((Supplier)object.getRedSandCast(), "Red Sand " + this.capitalize(object.getName().m_135815_()));
    }

    public void addMaterial(MaterialId material, String name, String flavour, String desc) {
        String id = material.m_135815_();
        this.add("material.tinkers_reforged." + id, name);
        if (!flavour.equals("")) {
            this.add("material.tinkers_reforged." + id + ".flavor", flavour);
        }
        if (!desc.equals("")) {
            this.add("material.tinkers_reforged." + id + ".encyclopedia", desc);
        }
    }

    public void addModifier(StaticModifier<Modifier> modifier, String name, String flavour, String desc) {
        String id = modifier.getId().m_135815_();
        this.add("modifier.tinkers_reforged." + id, name);
        this.add("modifier.tinkers_reforged." + id + ".flavor", flavour);
        this.add("modifier.tinkers_reforged." + id + ".description", desc);
    }

    public void addFluid(FluidObject<ForgeFlowingFluid> supplier, String name) {
        this.add(String.format("fluid.%s.%s", "tinkers_reforged", supplier.getId().m_135815_().replace("_flowing", "")), name);
    }

    public void addGroup(String value) {
        this.add(String.format("itemGroup.%s", "tinkers_reforged"), value);
    }

    public String capitalize(String input) {
        if (input.contains("_")) {
            String[] split = input.split("_");
            StringBuilder output = new StringBuilder();
            for (String s : split) {
                output.append(StringUtils.capitalize((String)s));
                output.append(" ");
            }
            return output.toString().trim();
        }
        return StringUtils.capitalize((String)input);
    }
}

